---
title: DHCP static address reservation · Cloudflare One docs
description: "If you configure your Magic WAN Connector to be a DHCP server, you
  can also assign IP addresses to specific devices on your network. To reserve
  IP addresses:"
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/network-options/dhcp/dhcp-static-address-reservation/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/network-options/dhcp/dhcp-static-address-reservation/index.md
---

If you configure your Magic WAN Connector to be a DHCP server, you can also assign IP addresses to specific devices on your network. To reserve IP addresses:

* Dashboard

  1. Configure your Magic WAN Connector to be a [DHCP server](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/network-options/dhcp/dhcp-server/).
  2. Select **Add DHCP Reservation**.
  3. In **Hardware Address** enter the [MAC address](https://en.wikipedia.org/wiki/MAC_address) for the device you want a specific IP address for.
  4. In **IP Address**, enter the IP address for that device.
  5. (Optional) If you need to reserve more IP addresses, select **Add DHCP Reservation** as many times as needed, and enter the new values.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API token](https://developers.cloudflare.com/fundamentals/api/get-started/account-owned-tokens/) to use the API.

  Create a [`PUT` request](https://developers.cloudflare.com/api/resources/magic_transit/subresources/sites/subresources/lans/methods/update/) to update the LAN where you want to reserve addresses:

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/sites/$SITE_ID/lans/$LAN_ID" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "lan": {
          "static_addressing": {
              "dhcp_server": {
                  "reservations": {
                      "<HARDWARE_MAC_ADDRESS>": "<IP_ADDRESS>",
                      "<HARDWARE_MAC_ADDRESS_2>": "<IP_ADDRESS>"
                  }
              }
          }
      }
    }'
  ```
