---
title: Why Spectrum-enabled hostnames might appear in Layer 7 Analytics ·
  Cloudflare Spectrum docs
description: >-
  Even when you have Spectrum enabled to handle Layer 4 traffic (for example,
  TCP/UDP connections), you may still notice traffic in your Layer 7 (L7)
  analytics dashboard. This is due to the way Cloudflare's Layer 7 CDN

  and Spectrum handle customer identity differently.
lastUpdated: 2024-10-18T13:20:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/spectrum/reference/layer-7-analytics/
  md: https://developers.cloudflare.com/spectrum/reference/layer-7-analytics/index.md
---

Even when you have Spectrum enabled to handle Layer 4 traffic (for example, TCP/UDP connections), you may still notice traffic in your Layer 7 (L7) analytics dashboard. This is due to the way Cloudflare's Layer 7 CDN and Spectrum handle customer identity differently.

## How Spectrum identifies a user (Layer 4)

In Spectrum, the identity of the customer hostname is based on the Cloudflare IP address that the client uses to connect to the edge. Here is the typical process:

1. Spectrum sets up a DNS hostname in the customer's zone that points to its Spectrum edge IP, and links this edge IP and port to the customer's configuration.
2. The client performs a DNS lookup on the Spectrum hostname, retrieves the Spectrum edge IP, and connects to that IP and port.
3. Spectrum uses this edge IP and port to match the connection to the customer's configuration, identifying the customer.

This process focuses on Layer 4 associating a hostname and customer configuration around IP addresses and ports.

## How the CDN identifies a user (Layer 7)

1. The customer sets up a DNS hostname in their zone that directs traffic to their origin server.
2. The client performs a DNS lookup on the CDN hostname, and the DNS server responds with a CDN edge IP. In contrast to Spectrum, the CDN edge IP is primarily used for traffic management rather than customer identity, as multiple customers can share the same CDN edge IP.

For the CDN, identifying the customer relies heavily on resolving hostnames during the TLS handshake (SNI) and the HTTP request (`Host` header). Notably, the CDN is designed to accept any hostname that matches the customer's zone (for example, `*.example.com`), even if there is no specific Layer 7 DNS match. This means that even Spectrum or Load Balancer hostnames will be accepted as valid under `*.example.com`.

## The overlap: Layer 7 traffic being proxied through Spectrum

Because the CDN is designed to accept any hostname under your zone (for example, `spectrum.example.com`), HTTP traffic that should first be proxied by Spectrum, or even HTTP traffic meant for a Layer-4-only Spectrum app, may sometimes be processed directly by the Layer 7 CDN system. The process is the following:

1. The client connects to a Layer 7 CDN edge IP while using the hostname of a Spectrum application (for example, `spectrum.example.com`) during both the TLS handshake and the HTTP request. Essentially, this means the client is attempting to access `spectrum.example.com` on an incorrect IP.
2. The CDN accepts this hostname as part of the customer zone during both the TLS and HTTP phases because it is designed to recognize any hostname under `*.example.com`. As a result, the request passes through the CDN under the zone's identity.
3. However, when the CDN attempts to connect to the origin server, it performs an internal DNS lookup of the HTTP hostname, which resolves to the Spectrum IP (from `spectrum.example.com` to the Spectrum edge IP). Consequently, the CDN establishes an origin connection to Spectrum, loading its configuration and forwarding the request to the Spectrum origin.

This means traffic for this hostname undergoes the standard Layer 7 CDN products, including Analytics and logs.

## Blocking unwanted L7 traffic

If you want to prevent traffic for Layer-4-only Spectrum hostnames from being proxied through Layer 7 to your origin (including unwanted scans or requests), we recommend implementing a Layer 7 WAF (Web Application Firewall) rule. This rule can block traffic directed at specific hostnames or ports, ensuring that only legitimate traffic reaches your Spectrum service.

For example, you can create a WAF rule to block requests to `spectrum.example.com` unless they originate from a Spectrum IP or a customer's Spectrum BYOIP. The traffic will still be logged in Layer 7 Analytics, including WAF Security Events, but this prevents it from arriving at the wrong address and looping through the CDN a second time.
